	function H = FREQZ_LWDF_C(c,w,L)
	
	% 	Computes the complementary magnitude function for an odd-order lattice filter 	
	
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Hakan Johansson 1996-05-04
	% 	Modified by: 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	
	% 	Known bugs:	 
	% 	Report bugs to:	larsw@isy.liu.se
	
	H0 = 1;
	for k=2:4:length(c)
		H0=H0.*(-c(k)-c(k+1)*(1-c(k))*exp(-j*L*w)+exp(-j*2*L*w));
		H0=H0./(1-c(k+1)*(1-c(k))*exp(-j*L*w)-c(k)*exp(-j*2*L*w));
	end

	H1 = (-c(1)+exp(-j*L*w))./(1-c(1)*exp(-j*L*w));
	for k=4:4:length(c)
		H1=H1.*(-c(k)-c(k+1)*(1-c(k))*exp(-j*L*w)+exp(-j*2*L*w));
		H1=H1./(1-c(k+1)*(1-c(k))*exp(-j*L*w)-c(k)*exp(-j*2*L*w));
	end

	H=(H0-H1)/2;
	
